import { Camera, Mail, Phone, MapPin, Clock } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Camera size={28} strokeWidth={2} className="footer-logo-icon" />
              <h2 className="footer-logo-text">PhotoAcademy</h2>
            </div>
            <p className="footer-description">
              Профессиональные онлайн-курсы по цифровой фотографии.
            </p>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={18} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={18} strokeWidth={2} />
                <a href="mailto:info@photoacademy.ru">info@photoacademy.ru</a>
              </li>
              <li>
                <MapPin size={18} strokeWidth={2} />
                <span>г. Москва, ул. Фотографическая, д. 8</span>
              </li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Уровни курсов</h3>
            <ul className="footer-links">
              <li><a href="#">Начинающий</a></li>
              <li><a href="#">Продвинутый</a></li>
              <li><a href="#">Профессиональный</a></li>
              <li><a href="#">Ретушь</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Режим работы</h3>
            <ul className="footer-links">
              <li>
                <Clock size={16} strokeWidth={2} />
                <span>Пн-Вс: 9:00 - 21:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 PhotoAcademy. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

